/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connserv;

import com.ibm.hwmca.fw.connserv.CommPath;
import com.ibm.hwmca.fw.connserv.PathQueueListener;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistenceReadException;
import com.ibm.hwmca.fw.persist.PersistenceWriteException;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class CommPathManager {
    private static final String TRACE_T = "XRCSCPMT";
    private static final String TRACE_F = "XRCSCPMF";
    private static final int idleTimeout = 60;
    private static final String CPM_PERSISTENT_NAME = "com.ibm.hwmca.fw.connserv.CommPathManager";
    static CommPathManager cpm;
    private Map pathMap = new HashMap();
    private List waitingPaths = new LinkedList();
    private List activePaths = new LinkedList();
    private int eventSN = 0;
    private boolean queueEnabled = true;
    private boolean RCSOutboundEnabled = true;
    private boolean RCSInboundEnabled = false;
    private Object eventMonitor = new Object();
    private LinkedList eventQueue = new LinkedList();
    private Thread eventThread;
    private Object listenerLock = new Object();
    private List queueListeners = new ArrayList();
    private int nextListenerSN = 1;
    private static int NO_LISTENER_SN;
    private static final int EVENT_ADDED_TO_WAITING = 0;
    private static final int EVENT_REMOVED_FROM_WAITING = 1;
    private static final int EVENT_REORDERED_IN_WAITING = 2;
    private static final int EVENT_MOVED_FROM_WAITING_TO_ACTIVE = 3;
    private static final int EVENT_REMOVED_FROM_ACTIVE = 4;
    private static final String[] eventNames;

    private static void trace(String msg) {
        Trace.trace(TRACE_T, msg);
    }

    private static void fdbg(String msg) {
        Trace.trace(TRACE_F, msg);
    }

    public static synchronized CommPathManager getCommPathManager() {
        if (cpm == null) {
            CommPathManager.reconstitute();
            if (cpm == null) {
                cpm = new CommPathManager();
            }
        }
        return cpm;
    }

    private CommPathManager() {
    }

    private CommPathManager(PersistentData persistent) {
        Persistent pd = (Persistent)persistent;
        this.queueEnabled = pd.queueEnabled;
        this.RCSOutboundEnabled = !pd.RCSOutboundDisabled;
        this.RCSInboundEnabled = pd.RCSInboundEnabled;
    }

    private void persist() {
        Persistent pd = new Persistent();
        pd.queueEnabled = this.queueEnabled;
        pd.RCSOutboundDisabled = !this.RCSOutboundEnabled;
        pd.RCSInboundEnabled = this.RCSInboundEnabled;
        try {
            PersistenceManager.getPersistenceManager().write(CPM_PERSISTENT_NAME, pd);
            CommPathManager.trace("<> persist() Ok, CommPathMgr persistent state saved");
        }
        catch (PersistenceWriteException e) {
            CommPathManager.trace("<> persist() EXC: PersistenceWriteException was thrown");
            throw new RuntimeException("A PersistenceWriteException occurred when saving persistent state");
        }
        catch (PersistenceException e) {
            CommPathManager.trace("<> persist() EXC: PersistenceException other than Write was thrown");
            CommPathManager.trace("<> persist() EXC: PersistenceException was thrown");
            throw new RuntimeException("A PersistenceException occurred when saving persistent state");
        }
    }

    private static void reconstitute() {
        Persistent pd = null;
        try {
            pd = (Persistent)PersistenceManager.getPersistenceManager().read(CPM_PERSISTENT_NAME);
            if (pd == null) {
                return;
            }
            cpm = new CommPathManager(pd);
            CommPathManager.trace("<> reconstitute() Ok, CommPathMgr reconstitued from persistent state");
        }
        catch (PersistenceReadException e) {
            CommPathManager.trace("<> reconstitute() EXC: PersistenceReadException was thrown");
            throw new RuntimeException("A PersistenceReadException occurredwhen reconstituting object");
        }
        catch (PersistenceException e) {
            CommPathManager.trace("<> persist() EXC: PersistenceException other than Read was thrown");
            throw new RuntimeException("A PersistenceException occurred when reconstituting object");
        }
    }

    public synchronized CommPath getPathById(int id) {
        String meth = " getPathById(#" + id + ") ";
        CommPath result = null;
        QueueEntry qe = (QueueEntry)this.pathMap.get(new Integer(id));
        if (qe != null) {
            result = qe.getPath();
            if (result != null) {
                CommPathManager.trace("<>" + meth + "Ok, path found");
            } else {
                CommPathManager.trace("<>" + meth + "Failed, path is a zombie");
            }
        } else {
            CommPathManager.trace("<>" + meth + "Failed, path not found");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prioritizeCommPath(CommPath path) throws IllegalStateException {
        String meth = " prioritizeCommPath(#" + path.getId() + ") ";
        CommPathManager.trace("->" + meth);
        CommPathManager commPathManager = this;
        synchronized (commPathManager) {
            if (path.getState() != 1) {
                CommPathManager.trace("<-" + meth + "EXC: CommPath is not in queued statee");
                throw new IllegalStateException("CommPath is not in the queued state");
            }
            QueueEntry qekey = new QueueEntry(path.getId());
            int pos = this.waitingPaths.indexOf(qekey);
            if (pos == -1) {
                String msg = "CommPath in Queued state is not in the waiting queue as it should be";
                CommPathManager.trace("<-" + meth + "EXC (Internal Error): " + msg);
                throw new RuntimeException("Internal Error - " + msg);
            }
            QueueEntry qe = (QueueEntry)this.waitingPaths.remove(pos);
            this.waitingPaths.add(0, qe);
            this.fireEvent(new EventData(2, path, qe.filterThreshhold, 0));
            CommPathManager.trace("<-" + meth + "Ok, path moved to front of high prio queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List[] getQueuedPaths(PathQueueListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            CommPathManager commPathManager = this;
            synchronized (commPathManager) {
                int thisListenerSN = NO_LISTENER_SN;
                if (listener != null) {
                    thisListenerSN = this.nextListenerSN++;
                }
                String moreMsg = "";
                List[] returnedLists = new List[2];
                List[] sourceLists = new List[]{this.activePaths, this.waitingPaths};
                for (int i = 0; i < sourceLists.length; ++i) {
                    ArrayList<CommPath> l = new ArrayList<CommPath>(sourceLists[i].size());
                    Iterator iter = sourceLists[i].iterator();
                    while (iter.hasNext()) {
                        QueueEntry qe = (QueueEntry)iter.next();
                        CommPath p = qe.getPath();
                        if (p != null) {
                            l.add(p);
                            continue;
                        }
                        CommPathManager.fdbg("Omitting zombie path #" + qe.id + " from the lists we're building");
                        if (qe.filterThreshhold != NO_LISTENER_SN) continue;
                        qe.filterThreshhold = thisListenerSN;
                    }
                    returnedLists[i] = l;
                }
                if (listener != null) {
                    ListenerEntry le = new ListenerEntry(listener, this.nextListenerSN, this.eventSN);
                    if (!this.queueListeners.contains(le)) {
                        this.queueListeners.add(le);
                        moreMsg = "and new listener registered";
                    } else {
                        moreMsg = "BUT listener was already registered";
                        le = (ListenerEntry)this.queueListeners.get(this.queueListeners.indexOf(le));
                        le.eventSN = this.eventSN;
                    }
                }
                CommPathManager.trace("<> getQueuedPaths() Returning lists (" + returnedLists[0].size() + " active, " + returnedLists[1].size() + " waiting) " + moreMsg);
                return returnedLists;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(PathQueueListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            ListenerEntry lekey = new ListenerEntry(listener);
            if (this.queueListeners.remove(lekey)) {
                CommPathManager.trace("<> removeQueueListener() Ok, listener deregistered");
            } else {
                CommPathManager.trace("<> removeQueueListener() Hmm, listener was not registered");
            }
        }
    }

    public void cancelAllActiveCommPaths() {
        CommPathManager.trace("<> cancelAllActiveCommPaths() No Op, not currently implemented");
    }

    public void cancelAllWaitingCommPaths() {
        CommPathManager.trace("<> cancelAllWaitingCommPaths() No Op, not currently implemented");
    }

    public synchronized void setProcessingEnabled(boolean flag) {
        String msg;
        if (flag != this.queueEnabled) {
            this.queueEnabled = flag;
            this.persist();
            msg = "Ok, processing is now ";
        } else {
            msg = "No change, processing remains ";
        }
        CommPathManager.trace("<> setProcessing Enabled() " + msg + (flag ? "enabled" : "disabled"));
    }

    public boolean isProcessingEnabled() {
        return this.queueEnabled;
    }

    public synchronized void setRCSOutboundEnabled(boolean flag) {
        String msg;
        if (flag != this.RCSOutboundEnabled) {
            this.RCSOutboundEnabled = flag;
            this.persist();
            msg = "Ok, RCS is now ";
        } else {
            msg = "No change, RCS remains ";
        }
        CommPathManager.trace("<> setRCSOutboundEnabled() " + msg + (flag ? "enabled" : "disabled"));
    }

    public boolean isRCSOutboundEnabled() {
        return this.RCSOutboundEnabled;
    }

    public void initializeConnectionServices() {
        CommPathManager.trace("<> initializeConnecitonServices() No Op, not currently implemented");
    }

    public void terminateConnectionServices() {
        CommPathManager.trace("<> terminateConnecitonServices() No Op, not currently implemented");
    }

    private void addToPathMap(QueueEntry qe) {
        this.pathMap.put(new Integer(qe.id), qe);
    }

    private void removeFromPathMap(QueueEntry qe) {
        this.pathMap.remove(new Integer(qe.id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToWaitingQueue(CommPath path) throws RuntimeException {
        String meth = " addToWaitingQueue(#" + path.getId() + ") ";
        CommPathManager.trace("->" + meth);
        CommPathManager commPathManager = this;
        synchronized (commPathManager) {
            QueueEntry qe = new QueueEntry(path);
            if (this.waitingPaths.contains(qe)) {
                String msg = "Caller attempted to add a path that was already in the waiting queue";
                CommPathManager.trace("<-" + meth + "EXC (Internal Error): " + msg);
                throw new RuntimeException("Internal Error - " + msg);
            }
            int newPathPrio = path.getPriority();
            ListIterator<QueueEntry> iter = this.waitingPaths.listIterator();
            while (iter.hasNext()) {
                CommPath p = ((QueueEntry)iter.next()).getPath();
                if (p == null || p.getPriority() >= newPathPrio) continue;
                iter.previous();
                break;
            }
            int insertPosition = iter.nextIndex();
            iter.add(qe);
            this.addToPathMap(qe);
            this.fireEvent(new EventData(0, path, qe.filterThreshhold, insertPosition));
            CommPathManager.trace("<-" + meth + "Ok, path added at position " + insertPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromWaitingQueue(CommPath path) throws RuntimeException {
        String meth = " removeFromWaitingQueue(#" + path.getId() + ") ";
        CommPathManager.trace("->" + meth);
        QueueEntry qekey = new QueueEntry(path.getId());
        CommPathManager commPathManager = this;
        synchronized (commPathManager) {
            this.removeFromPathMap(qekey);
            int pos = this.waitingPaths.indexOf(qekey);
            if (pos == -1) {
                String msg = "Caller attempted to remove a path that was not in the waiting queue";
                CommPathManager.trace("<-" + meth + "EXC (Internal Error): " + msg);
                throw new RuntimeException("Internal Error - " + msg);
            }
            QueueEntry qe = (QueueEntry)this.waitingPaths.remove(pos);
            this.fireEvent(new EventData(1, path, qe.filterThreshhold));
            CommPathManager.trace("<-" + meth + "Ok, path removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveFromWaitingToActiveQueue(CommPath path) throws RuntimeException {
        String meth = " moveFromWaitingToActive(#" + path.getId() + ") ";
        CommPathManager.trace("->" + meth);
        CommPathManager commPathManager = this;
        synchronized (commPathManager) {
            QueueEntry qekey = new QueueEntry(path.getId());
            int pos = this.waitingPaths.indexOf(qekey);
            if (pos == -1) {
                String msg = "Caller attempted to move a path from waiting to active that was not in the waiting queue";
                CommPathManager.trace("<-" + meth + "EXC (Internal Error): " + msg);
                throw new RuntimeException("Internal Error - " + msg);
            }
            if (this.activePaths.contains(qekey)) {
                String msg = "Caller attempted to move a path from waiting to active was already in the active queue";
                CommPathManager.trace("<-" + meth + "EXC (Internal Error): " + msg);
                throw new RuntimeException("Internal Error - " + msg);
            }
            QueueEntry qe = (QueueEntry)this.waitingPaths.remove(pos);
            this.activePaths.add(qe);
            this.fireEvent(new EventData(3, path, qe.filterThreshhold));
            CommPathManager.trace("<-" + meth + "Ok, path now in active queue");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromActiveQueue(CommPath path) {
        String meth = " removeFromActiveQueue(#" + path.getId() + ") ";
        CommPathManager.trace("->" + meth);
        CommPathManager commPathManager = this;
        synchronized (commPathManager) {
            QueueEntry qekey = new QueueEntry(path.getId());
            this.removeFromPathMap(qekey);
            int pos = this.activePaths.indexOf(qekey);
            if (pos == -1) {
                String msg = "Caller attempted to remove a path that was not in the active queue";
                CommPathManager.trace("<-" + meth + "EXC (Internal Eror): " + msg);
                throw new RuntimeException("Internal Error - " + msg);
            }
            QueueEntry qe = (QueueEntry)this.activePaths.remove(pos);
            this.fireEvent(new EventData(4, path, qe.filterThreshhold));
            CommPathManager.trace("<-" + meth + "Ok, path removed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(EventData data) {
        String meth = " fireEvent() ";
        data.eventSN = ++this.eventSN;
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.queueListeners.isEmpty()) {
                CommPathManager.trace("<>" + meth + "No Op, no listeners currently registered");
                return;
            }
        }
        boolean startedThread = false;
        boolean nudgedThread = false;
        Object object2 = this.eventMonitor;
        synchronized (object2) {
            if (this.eventThread == null) {
                this.eventThread = new Thread(new Runnable(){

                    public void run() {
                        CommPathManager.this.deliverEvents();
                    }
                }, "CPM Event Thread");
                this.eventThread.setDaemon(true);
                this.eventThread.start();
                startedThread = true;
            }
            this.eventQueue.add(data);
            if (this.eventQueue.size() == 1) {
                this.eventMonitor.notify();
                nudgedThread = true;
            }
            if (startedThread) {
                CommPathManager.trace("<>" + meth + "Ok, event thread started and event queued");
            } else if (nudgedThread) {
                CommPathManager.trace("<>" + meth + "Ok, event queued and event thread nudged");
            } else {
                CommPathManager.trace("<>" + meth + "Ok, event queued");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deliverEvents() {
        String pfx = "CPM-Event-Thr: ";
        CommPathManager.trace(pfx + "Started");
        while (true) {
            EventData event;
            Object object = this.eventMonitor;
            synchronized (object) {
                long interval;
                long waitUntil = System.currentTimeMillis() + 60000L;
                while (this.eventQueue.isEmpty() && (interval = waitUntil - System.currentTimeMillis()) > 0L) {
                    try {
                        this.eventMonitor.wait(interval);
                    }
                    catch (InterruptedException e) {}
                }
                if (this.eventQueue.isEmpty()) {
                    this.eventThread = null;
                    CommPathManager.trace(pfx + "Exiting due to idle timeout");
                    return;
                }
                event = (EventData)this.eventQueue.remove(0);
            }
            if (event.type < 0 || event.type >= eventNames.length) {
                CommPathManager.fdbg(pfx + "Ignoring event with unrecognized type: " + event.type);
                continue;
            }
            object = this.listenerLock;
            synchronized (object) {
                ArrayList ll = new ArrayList(this.queueListeners);
                if (ll.isEmpty()) {
                    CommPathManager.trace(pfx + "Discarding " + eventNames[event.type] + " event for path #" + event.path.getId() + " since no listeners are now registered");
                } else {
                    CommPathManager.trace(pfx + "Delivering " + eventNames[event.type] + " event for path #" + event.path.getId() + " to " + ll.size() + " listener(s)");
                }
                Iterator iter = ll.iterator();
                while (iter.hasNext()) {
                    ListenerEntry le = (ListenerEntry)iter.next();
                    PathQueueListener listener = le.listener;
                    if (event.filterThreshhold != NO_LISTENER_SN && event.filterThreshhold <= le.listenerSN || event.eventSN <= le.eventSN) {
                        CommPathManager.trace(pfx + "Supressing zombie-related event for listener: " + listener.getClass().getName());
                        continue;
                    }
                    try {
                        CommPathManager.trace(pfx + "Calling listener: " + listener.getClass().getName());
                        switch (event.type) {
                            case 0: {
                                listener.addedToWaiting(event.path, event.position);
                                break;
                            }
                            case 1: {
                                listener.removedFromWaiting(event.path);
                                break;
                            }
                            case 2: {
                                listener.reorderInWaiting(event.path, event.position);
                                break;
                            }
                            case 3: {
                                listener.moveFromWaitingToActive(event.path);
                                break;
                            }
                            case 4: {
                                listener.removedFromActive(event.path);
                            }
                        }
                    }
                    catch (Exception e) {
                        CommPathManager.fdbg(pfx + "Swallowing exeption (" + e + ") thrown by listener");
                    }
                }
                if (!ll.isEmpty()) {
                    CommPathManager.trace(pfx + "Done delivering event");
                }
            }
        }
    }

    static {
        NO_LISTENER_SN = 0;
        eventNames = new String[]{"addedToWaiting", "removedFromWaiting", "reorderedInWaiting", "movedFromWaitingToActive", "removedFromActive"};
    }

    private static class EventData {
        int type;
        CommPath path;
        int filterThreshhold;
        int position;
        int eventSN;

        EventData(int type, CommPath path, int filterThreshhold, int position) {
            this.type = type;
            this.path = path;
            this.filterThreshhold = filterThreshhold;
            this.position = position;
        }

        EventData(int type, CommPath path, int filterThreshhold) {
            this.type = type;
            this.path = path;
            this.filterThreshhold = filterThreshhold;
            this.position = 0;
        }
    }

    private static class QueueEntry {
        int id;
        WeakReference pathRef;
        int filterThreshhold;

        QueueEntry(CommPath path) {
            this.id = path.getId();
            this.pathRef = path.getRef();
            this.filterThreshhold = NO_LISTENER_SN;
        }

        QueueEntry(int pathId) {
            this.id = pathId;
            this.pathRef = null;
            this.filterThreshhold = NO_LISTENER_SN;
        }

        CommPath getPath() {
            return (CommPath)this.pathRef.get();
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof QueueEntry)) {
                return false;
            }
            return this.id == ((QueueEntry)other).id;
        }
    }

    private static class ListenerEntry {
        PathQueueListener listener;
        int listenerSN;
        int eventSN = 0;

        ListenerEntry(PathQueueListener listener, int listenerSN, int eventSN) {
            this.listener = listener;
            this.listenerSN = listenerSN;
            this.eventSN = eventSN;
        }

        ListenerEntry(PathQueueListener listener) {
            this.listener = listener;
            this.listenerSN = NO_LISTENER_SN;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof ListenerEntry)) {
                return false;
            }
            return this.listener == ((ListenerEntry)other).listener;
        }
    }

    private static class Persistent
    implements PersistentData {
        static final long serialVersionUID = -1L;
        boolean queueEnabled;
        boolean RCSOutboundDisabled;
        boolean RCSInboundEnabled;

        private Persistent() {
        }
    }
}

